from fractions import Fraction
import sys

sys.set_int_max_str_digits(1000000)

A, B = [int(i) for i in input().split()]

if A == B or B == 0 or A == 0: # Sample or Fermats last theorem
    print("impossible")
else:
    A_cur = Fraction(A, 1)
    B_cur = Fraction(B, 1)
    while True:
        # Keep duplicating point
        A_new = (A_cur * (A_cur ** 3 + 2 * B_cur ** 3)) / (A_cur ** 3 - B_cur ** 3)
        B_new = (-B_cur * (2 * A_cur ** 3 + B_cur ** 3)) / (A_cur ** 3 - B_cur ** 3)
        A_cur = A_new
        B_cur = B_new
        # Until a positive solution is found
        if A_cur > 0 and B_cur > 0:
            print(f"{A_cur.numerator}/{A_cur.denominator}") #dont do print(A_cur) as prints integers as n and not n/1
            print(f"{B_cur.numerator}/{B_cur.denominator}")
            break
